#include "SignInSony.h"
#include "toolkit.h"
#include "UserProfileSony.h"
#include "MessagePipe.h"
#include "ErrorCodesSony.h"

#if NP_HAS_RANKING
 #include "RankingSony.h"
#endif
using namespace sce::Toolkit::NP;
using namespace sce::Toolkit::NP::Utilities;

namespace UnityPlugin
{
	SignedInState gSignedInState;
	int gCurrentPS4UserId=0;

	DO_EXPORT( ErrorCode, PrxSignin ) ()
	{
		return gSignedInState.SignIn();
	}

	DO_EXPORT( bool, PrxSigninIsBusy ) ()
	{
		return gSignedInState.IsBusy();
	}

	DO_EXPORT( bool, PrxIsSignedIn ) ()
	{
		return gSignedInState.IsSignedIn();
	}

	DO_EXPORT( bool, PrxSigninGetLastError ) (ResultCode* result)
	{
		return gSignedInState.GetLastError(result);
	}

	DO_EXPORT( int, PrxSetCurrentUserId ) (int UserId)
	{
		int lastValue = gCurrentPS4UserId;
		gCurrentPS4UserId = UserId;
		return lastValue;
	}

	DO_EXPORT( int, PrxGetCurrentUserId ) ()
	{
		return gCurrentPS4UserId;
	}

	DO_EXPORT( int, PrxLogOutUser ) (int UserId)
	{
		return 0;
	}

	DO_EXPORT( int, PrxGetUserSigninStatus ) (int userID, void **npid)
	{
		return 0;
	}

	
	
	SignedInState::SignedInState()
		: m_Busy(false)
		, m_DialogOpen(false)
		, m_PlatformSignedIn(false)
		, m_ApplicationSignedIn(false)
		, m_LastResult("SignIn")
	{
	}

	bool SignedInState::IsBusy()
	{
		SimpleLock::AutoLock lock(m_Lock);
		return m_Busy;
	}

	ErrorCode SignedInState::SignIn()
	{
		bool TriggerSignInSuccessful = false;
		{
			if(IsBusy())
			{
				return m_LastResult.SetResult(NP_ERR_BUSY, true);
			}

			SimpleLock::AutoLock lock(m_Lock);

			if(m_DialogOpen)
			{
				return m_LastResult.SetResult(NP_ERR_BUSY, true);
			}

			m_LastResult.Reset();

			int ret = NetInfo::Interface::psnLoginDialogStart();
			if(ret == SCE_TOOLKIT_NP_SUCCESS)
			{
				m_DialogOpen = true;
				m_Busy = true;
			}
			else
			{
				return m_LastResult.SetResultSCE(ret, true, __FUNCTION__, __LINE__);
			}
		}

		if (TriggerSignInSuccessful == true)	// this has to be done outside of the lock 
		{
			SignInSuccessful();
		}

		return m_LastResult.GetResult();
	}

	bool SignedInState::ProcessEvent(const sce::Toolkit::NP::Event& npevent)
	{
		SimpleLock::AutoLock lock(m_Lock);
		bool handled = false;
		
		switch(npevent.event)
		{
		case Event::loggedIn:
			// This only signifies that the user is logged into PSN, not that the application is.
			m_PlatformSignedIn = true;
			handled = true;
			break;

		case Event::loggedOut:
			m_PlatformSignedIn = false;
			m_ApplicationSignedIn = false;
			Messages::AddMessage(Messages::kNPToolKit_SignedOut);
			handled = true;
			break;
			
		case Event::netInfoDialogComplete:
			if(npevent.returnCode == SCE_NP_MANAGER_STATUS_ONLINE )				// 0 is SCE_NP_MANAGER_STATUS_GETTING_TICKET in PS3 land
			{
				SignInSuccessful();
			}
			else if(npevent.returnCode == 1)	// Dialog canceled.
			{
				m_LastResult.SetResult(NP_ERR_NOT_SIGNED_IN, true, __FUNCTION__, __LINE__);
				Messages::AddMessage(Messages::kNPToolKit_SignInError);
			}
			else
			{
				m_LastResult.SetResultSCE(npevent.returnCode, true, __FUNCTION__, __LINE__);
				Messages::AddMessage(Messages::kNPToolKit_SignInError);
			}

			m_Busy = false;
			m_DialogOpen = false;
			handled = true;
			break;

		default:
			break;
		}

		return handled;
	}


	void SignedInState::SignInSuccessful(void)
	{
		m_PlatformSignedIn = true;
		m_ApplicationSignedIn = true;
		Messages::AddMessage(Messages::kNPToolKit_SignedIn);
	#if NP_HAS_RANKING
		if((gCreationFlags & kNpToolkitCreate_NoRanking) == 0)
		{
			// Initialize ranking cache.
			const int boardLineCount = 8;
			const int writeLineCount = 20;
			const bool friendCache = true;
			const int rangeLineCount = 121;
			UnityPlugin::gRanking.RegisterCache(boardLineCount, writeLineCount, friendCache, rangeLineCount);
		}
	#endif
		// Initialize user profile cache.
		UnityPlugin::gUserProfile.RequestUserProfile();
	}



} // namespace UnityPlugin
